from prompta.utils.java_libs import AbstractTTTLearner


# from collections import deque
# from typing import Any, Dict, Generic, Iterable, Iterator, Optional, Set, TypeVar, List, Union
# import jpype
# from jpype import JImplements, JOverride
# from pipelines.prompta.learner.ttt_utils.core.abstract_base_dt_node import AbstractBaseDTNode
# from pipelines.prompta.learner.ttt_utils.core.abstract_ttt_hypothesis import AbstractTTTHypothesis
# from pipelines.prompta.learner.ttt_utils.core.base_ttt_discrimination_tree import BaseTTTDiscriminationTree
# from pipelines.prompta.learner.ttt_utils.core.block_list import BlockList
# from pipelines.prompta.learner.ttt_utils.core.hypothesis_changed_exception import HypothesisChangedException
# from pipelines.prompta.learner.ttt_utils.core.ttt_state import TTTState
# from pipelines.prompta.learner.ttt_utils.core.ttt_transition import TTTTransition
# from pipelines.prompta.learner.ttt_utils.core.ttt_learner_state import TTTLearnerState
# from pipelines.prompta.learner.ttt_utils.core.incoming_list import IncomingList
# from pipelines.prompta.learner.ttt_utils.core.output_inconsistency import OutputInconsistency
# from prompta.utils.java_libs import *


# class BuilderDefaults:
#     def __init__(self) -> None:
#         # prevent instantiation
#         pass

#     @staticmethod
#     def analyzer() -> AcexAnalyzer:
#         return AcexAnalyzers.BINARY_SEARCH_BWD


# class Splitter:
#     def __init__(self, symbolIdx: int, succSeparator: AbstractBaseDTNode=None) -> None:
#         self.symbolIdx = symbolIdx

#         if succSeparator is not None:
#             assert not succSeparator.isTemp() and succSeparator.isInner()
#         self.succSeparator = succSeparator

#     def getDiscriminator(self) -> Word:
#         return self.succSeparator.getDiscriminator() if self.succSeparator is not None else Word.epsilon()

#     def getDiscriminatorLength(self) -> int:
#         return self.succSeparator.getDiscriminator().length() if self.succSeparator is not None else 0


# class GlobalSplitter:
#     def __init__(self, blockRoot: AbstractBaseDTNode, localSplitter: Splitter) -> None:
#         self.blockRoot = blockRoot
#         self.localSplitter = localSplitter


# class ExtractRecord:
#     def __init__(self, original: AbstractBaseDTNode, extracted: AbstractBaseDTNode) -> None:
#         self.original = original
#         self.extracted = extracted


# @JImplements(LearningAlgorithm, SupportsGrowingAlphabet, Resumable)
# class AbstractTTTLearner():
#     def __init__(self, alphabet, oracle: MembershipOracle, hypothesis, dtree: BaseTTTDiscriminationTree, analyzer: AcexAnalyzer):
#         self.alphabet: Alphabet = alphabet
#         self.oracle: MembershipOracle = oracle
#         self.analyzer: AcexAnalyzer = analyzer
#         self.open_transitions = IncomingList()
#         self.block_list = BlockList()
#         self.hypothesis: AbstractTTTHypothesis = hypothesis
#         self.dtree: BaseTTTDiscriminationTree = dtree

#     @staticmethod
#     def mark_and_propagate(node: AbstractBaseDTNode, label) -> None:
#         curr = node
#         while curr is not None and curr.getSplitData() is not None:
#             if not curr.getSplitData().mark(label): return
#             curr = curr.getParent()

#     @staticmethod
#     def move_incoming(new_node: AbstractBaseDTNode, old_node : AbstractBaseDTNode, label) -> None:
#         new_node.get_incoming().insertAllIncoming(old_node.getSplitData().get_incoming(label))
    
#     @staticmethod
#     def link(dt_node: AbstractBaseDTNode, state: TTTState) -> None:
#         assert dt_node.isLeaf()
#         dt_node.setData(state)
#         state.dtLeaf = dt_node

#     @JOverride
#     def startLearning(self) -> None:
#         if self.hypothesis.isInitialized():
#             raise Exception("Learning has already been initialized.")
#         init_state = self.hypothesis.initialize()
#         init_node = self.dtree.sift(init_state.getAccessSequence(), False)
#         self.link(init_node, init_state)
#         self.initialize_state(init_state)
#         self.close_transitions()

#     @JOverride
#     def refineHypothesis(self, ce_query: DefaultQuery) -> bool:
#         if not self.refine_hypothesis_single(ce_query):
#             return False
#         while self.refine_hypothesis_single(ce_query):
#             pass
#         return True

#     def initialize_state(self, state: TTTState) -> None:
#         for i in range(self.alphabet.size()):
#             sym = self.alphabet.getSymbol(i)
#             trans = self.create_transition(state, sym)
#             trans.set_non_tree_target(self.dtree.getRoot())
#             state.set_transition(i, trans)
#             self.open_transitions.insert_incoming(trans)

#     def create_transition(self, state: TTTState, sym) -> TTTTransition:
#         return TTTTransition(state, sym)

#     def refine_hypothesis_single(self, ce_query: DefaultQuery) -> bool:
#         state = self.get_any_state(ce_query.getPrefix())
#         out = self.compute_hypothesis_output(state, ce_query.getSuffix(), ce_query.getOutput())

#         if out == ce_query.getOutput():
#             return False

#         out_incons = OutputInconsistency(state, ce_query.getSuffix(), ce_query.getOutput())

#         while True:
#             self.split_state(out_incons)
#             self.close_transitions()
#             while self.finalize_any():
#                 self.close_transitions()

#             out_incons = self.find_output_inconsistency()
#             if out_incons is None:
#                 break
        
#         assert self.all_nodes_final()

#         return True
    
#     def split_state(self, *args, **kwargs) -> None:
#         if isinstance(args[0], TTTTransition):
#             self._split_state_transition(*args, **kwargs)
#         elif isinstance(args[0], OutputInconsistency):
#             self._split_state_output_inconsistency(*args, **kwargs)
#         else:
#             raise ValueError("Unsupported argument type for split_state")

#     def _split_state_transition(self, transition: TTTTransition, temp_discriminator: Word, old_out, new_out) -> None:
#         assert not transition.is_tree()

#         dt_node: AbstractBaseDTNode = transition.get_non_tree_target()
#         assert dt_node.isLeaf()
#         old_state: TTTState = dt_node.get_data()
#         assert old_state is not None

#         new_state = self.make_tree(transition)

#         children = dt_node.split(temp_discriminator, old_out, new_out)
#         dt_node.setTemp(True)

#         self.link(children.node_old, old_state)
#         self.link(children.node_new, new_state)

#         if dt_node.get_parent() is None or not dt_node.get_parent().isTemp():
#             self.block_list.insert_block(dt_node)

#     def _split_state_output_inconsistency(self, out_incons: OutputInconsistency) -> None:
#         acex = self.derive_acex(out_incons)
#         try:
#             breakpoint = self.analyzer.analyze_abstract_counterexample(acex)
#             assert not acex.testEffects(breakpoint, breakpoint + 1)

#             suffix = out_incons.suffix

#             pred_state = self.get_deterministic_state(out_incons.src_state, suffix.prefix(breakpoint))
#             succ_state = self.get_deterministic_state(out_incons.src_state, suffix.prefix(breakpoint + 1))
#             assert self.get_deterministic_state(pred_state, Word.from_letter(suffix.getSymbol(breakpoint))) == succ_state

#             sym = suffix.getSymbol(breakpoint)
#             split_suffix = suffix.subWord(breakpoint + 1)
#             trans = pred_state.get_transition(self.alphabet.getSymbolIndex(sym))
#             assert not trans.is_tree()
#             old_out = acex.effect(breakpoint + 1)
#             new_out = self.succ_effect(acex.effect(breakpoint))

#             self._split_state_transition(trans, split_suffix, old_out, new_out)
#         except HypothesisChangedException:
#             # ignore
#             pass

#     def derive_acex(self, out_incons: OutputInconsistency):
#         source = out_incons.src_state
#         suffix = out_incons.suffix

#         acex = OutInconsPrefixTransformAcex(suffix, self.oracle, lambda w: self.get_deterministic_state(source, w).get_access_sequence())
#         acex.setEffect(0, out_incons.target_out)
#         return acex

#     def succ_effect(self, effect) -> Any:
#         # Abstract method, to be implemented in subclass
#         raise NotImplementedError()

#     def finalize_any(self) -> bool:
#         splitter = self.find_splitter_global()
#         if splitter is not None:
#             self.finalize_discriminator(splitter.block_root, splitter.local_splitter)
#             return True
#         return False

#     def get_deterministic_state(self, start: TTTState, word: Word) -> TTTState:
#         last_singleton = start
#         last_singleton_index = 0

#         states: Set[TTTState] = {start}
#         i = 1
#         for sym in word:
#             next_states = self.get_nondet_successors(states, sym)
#             if len(next_states) == 1:
#                 last_singleton = next(iter(next_states))
#                 last_singleton_index = i
#             states = next_states
#             i += 1

#         if last_singleton_index == word.length():
#             return last_singleton

#         curr = last_singleton
#         for sym in word.subWord(last_singleton_index):
#             trans = curr.get_transition(self.alphabet.getSymbolIndex(sym))
#             curr = self.require_successor(trans)

#         return curr

#     def get_nondet_successors(self, states: Set[TTTState], sym) -> Set[TTTState]:
#         result = set()
#         sym_idx = self.alphabet.getSymbolIndex(sym)
#         for state in states:
#             trans = state.get_transition(sym_idx)
#             if trans.is_tree():
#                 result.add(trans.getTreeTarget())
#             else:
#                 tgt_node = trans.getNonTreeTarget()
#                 # Assuming Iterators.addAll is replaced with equivalent Python code
#                 result.update(tgt_node.subtreeStatesIterator())
#         return result

#     def get_any_successor(self, state: TTTState, sym_or_suffix: Union[Any, Iterable]) -> TTTState:
#         if isinstance(sym_or_suffix, Iterable) and not isinstance(sym_or_suffix, (str, bytes)):
#             return self._get_any_successor_iterable(state, sym_or_suffix)
#         else:
#             return self._get_any_successor_single(state, sym_or_suffix)

#     def _get_any_successor_single(self, state: TTTState, sym) -> TTTState:
#         sym_idx = self.alphabet.getSymbolIndex(sym)
#         trans = state.get_transition(sym_idx)
#         if trans.is_tree():
#             return trans.get_tree_target()
#         # Assuming subtreeStatesIterator().next() is properly implemented in Python
#         return next(trans.get_non_tree_target().subtreeStatesIterator())

#     def _get_any_successor_iterable(self, state: TTTState, suffix: Iterable) -> TTTState:
#         curr = state
#         for sym in suffix:
#             curr = self._get_any_successor_single(curr, sym)
#         return curr

#     def require_successor(self, trans: TTTTransition) -> TTTState:
#         if trans.is_tree():
#             return trans.get_tree_target()
#         new_tgt_node = self.update_dt_target(trans, True)
#         if new_tgt_node.get_data() is None:
#             self.make_tree(trans)
#             self.close_transitions()
#             raise HypothesisChangedException()
#         return new_tgt_node.get_data()

#     def find_splitter_global(self) -> Optional[GlobalSplitter]:
#         optimize_global = True
#         best_block_root = None
#         best_splitter = None
#         for block_root in self.block_list:
#             splitter = self.find_splitter(block_root)
#             if splitter and (best_splitter is None or splitter.getDiscriminatorLength() < best_splitter.getDiscriminatorLength()):
#                 best_splitter = splitter
#                 best_block_root = block_root
#                 if not optimize_global:
#                     break
#         if best_splitter is None:
#             return None
#         return GlobalSplitter(best_block_root, best_splitter)

#     def find_splitter(self, block_root: AbstractBaseDTNode) -> Optional[Splitter]:
#         alphabet_size = self.alphabet.size()
#         properties = [None for _ in range(alphabet_size)]
#         lcas = [AbstractBaseDTNode() for _ in range(alphabet_size)]
#         first = True

#         for state in block_root.subtree_states():
#             for i in range(alphabet_size):
#                 trans = state.get_transition(i)
#                 if first:
#                     properties = trans.getProperty()
#                     lcas = trans.get_dt_target()
#                 else:
#                     if not properties == trans.getProperty():
#                         return Splitter(i)
#                     lcas = self.dtree.leastCommonAncestor(lcas, trans.get_dt_target())
#             first = False

#         shortestLen = int(1e10)
#         shortestLca = None
#         shortestLcaSym = -1
            
#         for i in range(alphabet_size):
#             lca = lcas
#             if not lca.isTemp() and not lca.isLeaf():
#                 lca_len = lca.getDiscriminator().length()
#                 if shortestLca is None or lca_len < shortestLen:
#                     shortestLca = lca
#                     shortestLen = lca_len
#                     shortestLcaSym = i

#         if shortestLca is not None:
#             return Splitter(shortestLcaSym, shortestLca)
#         return None
    
#     def create_state(self, transition: TTTTransition) -> TTTState:
#         return self.hypothesis.createState(transition)

#     def get_any_target(self, trans: TTTTransition) -> TTTState:
#         if trans.is_tree():
#             return trans.get_tree_target()
#         return trans.get_non_tree_target().any_subtree_state()

#     def get_any_state(self, suffix: Iterable) -> TTTState:
#         return self.get_any_successor(self.hypothesis.getInitialState(), suffix)

#     def find_output_inconsistency(self) -> Optional[OutputInconsistency]:
#         best = None

#         for state in self.hypothesis.getStates():
#             node = state.getDTLeaf()
#             while not node.is_root():
#                 expectedOut = node.getParentOutcome()
#                 node = node.getParent()
#                 suffix = node.getDiscriminator()
#                 if best is None or suffix.length() < best.suffix.length():
#                     hypOut = self.compute_hypothesis_output(state, suffix)
#                     if hypOut != expectedOut:
#                         best = OutputInconsistency(state, suffix, expectedOut)
        
#         return best

#     def finalize_discriminator(self, block_root: AbstractBaseDTNode, splitter: Splitter):
#         assert block_root.isBlockRoot()

#         succ_discr = splitter.getDiscriminator().prepend(self.alphabet.get_symbol(splitter.symbolIdx))

#         if not block_root.getDiscriminator().equals(succ_discr):
#             final_discriminator = self.prepare_split(block_root, splitter)
#             rep_children: Dict[Any, AbstractBaseDTNode] = self.create_map()
#             for label in block_root.getSplitData().getLabels():
#                 rep_children[label] = self.extract_subtree(block_root, label)
#             block_root.replaceChildren(rep_children)

#             block_root.setDiscriminator(final_discriminator)

#         self.declare_final(block_root)

#     def all_nodes_final(self) -> bool:
#         it: Iterator[AbstractBaseDTNode] = self.dtree.getRoot().subtreeNodesIterator()
#         while next(it, None) is not None:
#             node = next(it)
#             assert not node.isTemp(), f"Final node with discriminator {node.getDiscriminator()}"
#         return True

#     def declare_final(self, block_root: AbstractBaseDTNode):
#         block_root.setTemp(False)
#         block_root.setSplitData(None)

#         block_root.removeFromBlockList()

#         for subtree in block_root.getChildren():
#             assert subtree.getSplitData() is None
#             block_root.setChild(subtree.getParentOutcome(), subtree)
#             # Register as blocks, if they are non-trivial subtrees
#             if subtree.isInner():
#                 self.block_list.insert_block(subtree)
#         self.open_transitions.insert_all_incoming(block_root.getIncoming())

#     def prepare_split(self, node: AbstractBaseDTNode, splitter: Splitter) -> Word:
#         symbolIdx = splitter.symbolIdx
#         symbol = self.alphabet.getSymbol(symbolIdx)
#         discriminator = splitter.getDiscriminator().prepend(symbol)
        
#         dfsStack = deque()
#         succSeparator = splitter.succSeparator
#         dfsStack.append(node)
#         assert node.getSplitData() is None
#         while len(dfsStack) > 0:
#             curr = dfsStack.pop()
#             assert curr.getSplitData() is None
#             curr.setSplitData(SplitData(IncomingList))
#             for trans in curr.getIncoming():
#                 outcome = self.query(trans, discriminator)
#                 curr.getSplitData().getIncoming(outcome).insertIncoming(trans)
#                 self.mark_and_propagate(curr, outcome)
#             if curr.isInner():
#                 for child in curr.getChildren():
#                     dfsStack.append(child)
#             else:
#                 state = curr.getData()
#                 assert state is not None
#                 trans = state.getTransition(symbolIdx)
#                 outcome = self.predict_succ_outcome(trans, succSeparator)
#                 assert outcome is not None
#                 curr.getSplitData().setStateLabel(outcome)
#                 self.mark_and_propagate(curr, outcome)

#         return discriminator
    
#     def predict_succ_outcome(self, trans: TTTTransition, succSeparator: AbstractBaseDTNode) -> Any:
#         raise NotImplementedError()

#     def extractSubtree(self, root: AbstractBaseDTNode, label) -> AbstractBaseDTNode:
#         assert root.getSplitData() is not None
#         assert root.getSplitData().isMarked(label)

#         stack = deque()
        
#         firstExtracted = self.create_new_node(root, label)

#         stack.append(ExtractRecord(root, firstExtracted))
#         while len(stack) > 0:
#             curr = stack.pop()
#             original = curr.original
#             extracted = curr.extracted

#             self.move_incoming(extracted, original, label)

#             if original.isLeaf():
#                 if original.getSplitData().getStateLabel() == label:
#                     self.link(extracted, original.getData())
#                 else:
#                     self.create_new_state(extracted)
#                 extracted.update_incoming()
#             else:
#                 marked_children = []
#                 for child in original.getChildren():
#                     if child.getSplitData().isMarked(label):
#                         marked_children.append(child)
#                 if len(marked_children) > 1:
#                     child_map = {}
#                     for c in marked_children:
#                         child_label = c.getParentOutcome()
#                         extracted_child = self.create_new_node(extracted, child_label)
#                         child_map[child_label] = extracted_child
#                         stack.append(ExtractRecord(c, extracted_child))
#                     extracted.setDiscriminator(original.getDiscriminator())
#                     extracted.replaceChildren(child_map)
#                     extracted.update_incoming()
#                     extracted.setTemp(True)
#                 elif len(marked_children) == 1:
#                     stack.append(ExtractRecord(marked_children[0], extracted))
#                 else:
#                     self.create_new_state(extracted)
#                     extracted.update_incoming()

#             assert extracted.getSplitData() is None

#         return firstExtracted
    
#     def create_map(self) -> Dict:
#         return {}

#     def create_new_state(self, new_node: AbstractBaseDTNode) -> None:
#         new_tree_trans = new_node.getIncoming().choose()
#         assert new_tree_trans is not None

#         new_state = self.create_state(new_tree_trans)
#         self.link(new_node, new_state)
#         self.initialize_state(new_state)

#     def compute_hypothesis_output(self, state: TTTState, suffix: Word) -> Any:
#         raise NotImplementedError()
        
#     def get_hypothesis(self) -> AbstractTTTHypothesis:
#         return self.hypothesis
    
#     def close_transitions(self, *args, **kwargs) -> Union[None, List[AbstractBaseDTNode]]:
#         """
#         If called without arguments, performs the closing of open transitions.
#         If called with an IncomingList and a boolean, performs the closing of specified transitions.
#         """
#         if len(args) == 0:
#             return self._close_transitions_no_args()
#         elif len(args) == 2 and isinstance(args[0], IncomingList) and isinstance(args[1], bool):
#             return self._close_transitions_with_args(args[0], args[1])
#         else:
#             raise ValueError("Invalid arguments for closeTransitions")

#     def _close_transitions_no_args(self) -> None:
#         """Ensures that all open transitions point to a leaf node."""
#         new_state_nodes = UnorderedCollection()  # Assuming a Python implementation or equivalent is available

#         while True:
#             new_state_nodes.extend(self._close_transitions_with_args(self.open_transitions, False))
#             if not new_state_nodes.isEmpty():
#                 self.add_new_states(new_state_nodes)
#             if not self.open_transitions.isEmpty():
#                 break

#     def _close_transitions_with_args(self, trans_list: IncomingList, hard: bool) -> List[AbstractBaseDTNode]:
#         """Ensures that the specified transitions point to a leaf-node."""
#         trans_to_sift = []

#         t = trans_list.poll()
#         while t is not None:
#             if not t.isTree():
#                 trans_to_sift.append(t)
#             t = trans_list.poll()

#         if not trans_to_sift:
#             return []

#         leaves_iter = self.update_dt_targets(trans_to_sift, hard).iterator()
#         result = [node for transition, node in zip(trans_to_sift, leaves_iter) if node.isLeaf() and node.getData() is None and transition.getNeextElement() is None]

#         assert not leaves_iter.has_next(), "Not all transitions were closed"
#         return result

#     def add_new_states(self, new_state_nodes: UnorderedCollection) -> None:
#         min_trans_node = None
#         min_trans = None
#         min_as_len = int(1e10)
#         min_trans_node_ref = None
#         for ref in new_state_nodes.references():
#             new_state_node = new_state_nodes.get(ref)
#             for trans in new_state_node.getIncoming():
#                 aseq = trans.get_access_sequence()
#                 as_len = len(aseq)
#                 if as_len < min_as_len:
#                     min_trans_node = new_state_node
#                     min_trans = trans
#                     min_as_len = as_len
#                     min_trans_node_ref = ref
#         assert min_trans_node is not None
#         new_state_nodes.remove(min_trans_node_ref)
#         state = self.make_tree(min_trans)
#         self.link(min_trans_node, state)
#         self.initialize_state(state)

#     def make_tree(self, trans: TTTTransition) -> TTTState:
#         assert not trans.is_tree()
#         node = trans.get_non_tree_target()
#         assert node.isLeaf()
#         state = self.create_state(trans)
#         trans.remove_from_list()
#         self.link(node, state)
#         self.initialize_state(state)
#         return state

#     def update_dt_target(self, trans: TTTTransition, hard: bool) -> AbstractBaseDTNode:
#         if trans.is_tree():
#             return trans.get_tree_target().dtLeaf
#         dt = trans.get_non_tree_target()
#         dt = self.dtree.sift(dt, trans.get_access_sequence(), hard)
#         trans.set_non_tree_target(dt)
#         return dt
    
#     def update_dt_targets(self, transitions: List[TTTTransition], hard: bool) -> List[AbstractBaseDTNode]:
#         nodes = []
#         prefixes = []
#         for t in transitions:
#             if not t.is_tree():
#                 nodes.append(t.get_non_tree_target())
#                 prefixes.append(t.get_access_sequence())
        
#         leaves_iter = self.dtree.sift(nodes, prefixes, hard).iterator()
#         result = []
#         for t in transitions:
#             if t.is_tree():
#                 result.append(t.get_tree_target().dtLeaf)
#             else:
#                 leaf = leaves_iter.next()
#                 t.set_non_tree_target(leaf)
#                 result.append(leaf)
        
#         assert not leaves_iter.has_next()
#         return result
    
#     def query(self, *args) -> Any:
#         """
#         Performs a membership query. This method intelligently handles both types of queries
#         based on the argument type.
#         """
#         # If the first argument is an AccessSequenceProvider, obtain the access sequence as the prefix.
#         if isinstance(args[0], AccessSequenceProvider):
#             prefix = args[0].getAccessSequence()
#             suffix = args[1]
#         # Otherwise, treat the first argument as the prefix directly.
#         else:
#             prefix, suffix = args
        
#         return self.oracle.answerQuery(prefix, suffix)
    
#     def get_diterministic_tree(self) -> BaseTTTDiscriminationTree:
#         return self.dtree
    
#     def split(self, node: AbstractBaseDTNode, discriminator: Word, old_out, new_out) -> AbstractDTNode.SplitResult:
#         return node.split(discriminator, old_out, new_out)

#     @JOverride
#     def addAlphabetSymbol(self, symbol) -> None:
#         if not self.alphabet.containsSymbol(symbol):
#             Alphabets.toGrowingAlphabetOrThrowException(self.alphabet).addSymbol(symbol)

#         self.hypothesis.addAlphabetSymbol(symbol)

#         # check if we already have information about the symbol (then the transition is defined) so we don't post
#         # redundant queries
#         if self.hypothesis.getInitialState() is not None and self.hypothesis.getState(Word.fromLetter(symbol)) is None:

#             newSymbolIdx = self.alphabet.getSymbolIndex(symbol)

#             for s in self.hypothesis.getStates():
#                 trans = self.create_transition(s, symbol)
#                 trans.set_non_tree_target(self.dtree.get_root())
#                 s.set_transition(newSymbolIdx, trans)
#                 self.open_transitions.insert_incoming(trans)

#             self.close_transitions()

#     def create_new_node(self, parent: AbstractBaseDTNode, parentOutput) -> AbstractBaseDTNode:
#         raise NotImplementedError()
    
#     @JOverride
#     def suspend(self) -> None:
#         return TTTLearnerState(self.hypothesis, self.dtree)
    
#     @JOverride
#     def resume(self, state: TTTLearnerState) -> None:
#         self.hypothesis = state.get_hypothesis()
#         self.dtree = state.get_discrimination_tree()
#         self.dtree.setOracle(self.oracle)

#         old_alphabet = self.hypothesis.getInputAlphabet()
#         if old_alphabet != self.alphabet:
#             raise Warning(f"The current alphabet '{self.alphabet}' differs from the resumed alphabet '{old_alphabet}'. Future behavior may be inconsistent")

#     @JOverride
#     def getHypothesisModel(self):
#         raise NotImplementedError()
